import { graphql } from 'react-relay/hooks';
import type { TachyonPage } from 'tachyon-next-types';
import type { VodInitialProps, VodPathParameters } from 'tachyon-page-utils';
import {
  vodGetInitialProps,
  vodIsFound,
  vodIsNotFoundServerside,
  vodPageviewTracking,
} from 'tachyon-page-utils';
import { MainVideoContainer } from '../../common';
import { useControllerContext } from '../../controller';
import { VodPlayerManager } from '../../player';
import type { Vod_QueryResponse } from './__generated__/Vod_Query.graphql';

export type VodProps = Vod_QueryResponse & VodInitialProps;

export const Vod: TachyonPage<VodInitialProps, VodProps, VodPathParameters> = ({
  video,
}) => {
  const { onPlayerEvent } = useControllerContext();

  if (!vodIsFound(video)) {
    // Treat a GraphQL error as a video error since it should be retryable:
    // 1) It's the consumer's responsibility to only request content that exists.
    // 2) We can't distinguish between 404 / 5xx errors in GQL. Assume it's the
    //    latter since the consumer should only be requesting valid content.
    onPlayerEvent('videoErrored');
    return null;
  }

  return (
    <MainVideoContainer>
      <VodPlayerManager video={video} />
    </MainVideoContainer>
  );
};

Vod.displayName = 'VodPage';
Vod.getInitialProps = vodGetInitialProps;
Vod.isNotFoundServerside = vodIsNotFoundServerside;
Vod.pageviewTracking = vodPageviewTracking;

Vod.query = graphql`
  query Vod_Query($videoId: ID!) {
    video(id: $videoId) {
      ...VodPlayerManager_video
      id
      broadcastType
      game {
        name
      }
      owner {
        id
        login
        stream {
          id
        }
      }
    }
  }
`;
