import { datatype, internet } from 'faker';
import { validId } from 'tachyon-relay';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { VodPlayerManager } from '../../player';
import { Vod } from '.';

const mockOnPlayerEvent = jest.fn();
jest.mock('../../controller', () => ({
  useControllerContext: () => ({
    onPlayerEvent: mockOnPlayerEvent,
  }),
}));

describe(Vod, () => {
  beforeEach(() => {
    mockOnPlayerEvent.mockReset();
  });

  describe('render', () => {
    const videoId = datatype.uuid();

    const setup = createShallowWrapperFactory(Vod, () => ({
      queryVariables: { videoId },
      video: {
        ' $fragmentRefs': { VodPlayerManager_video: true },
        broadcastType: 'ARCHIVE',
        game: {
          name: internet.userName(),
        },
        id: videoId,
        owner: {
          id: validId(),
          login: internet.userName(),
          stream: {
            id: validId(),
          },
        },
      },
    }));

    it('empty renders when video is not found and emits a videoError', () => {
      const { wrapper } = setup({ video: null });

      expect(mockOnPlayerEvent).toHaveBeenCalledTimes(1);
      expect(mockOnPlayerEvent).toHaveBeenCalledWith('videoErrored');
      expect(wrapper).toBeEmptyRender();
    });

    it('renders when video is found', () => {
      const { wrapper } = setup();
      expect(wrapper.find(VodPlayerManager)).toExist();
    });
  });
});
