import type { FC } from 'react';
import type { ClientSideErrorBoundaryProps } from 'tachyon-more-ui';
import { ClientSideErrorBoundary } from 'tachyon-more-ui';
import { useControllerContext } from '../../../controller';

interface PageErrorBoundaryProps extends ClientSideErrorBoundaryProps {}

export const PageErrorBoundary: FC<PageErrorBoundaryProps> = ({
  onError,
  ...props
}) => {
  const { onPlayerEvent } = useControllerContext();
  const errorHandler = () => {
    // Treat unhandled errors that are emitted from pages as video errors
    // as the error most likely occurred as part of the player loading / playing
    // process and is probably retryable
    onPlayerEvent('videoErrored');
    return onError?.();
  };

  return <ClientSideErrorBoundary onError={errorHandler} {...props} />;
};

PageErrorBoundary.displayName = 'PageErrorBoundary';
