import { sendEvent } from '../../../controller';
import { videoTagIsPresent } from './videoTagIsPresent';
import { onUnhandledError } from '.';

jest.mock('./videoTagIsPresent', () => ({
  videoTagIsPresent: jest.fn(),
}));

jest.mock('../../../controller', () => ({
  sendEvent: jest.fn(),
}));

const sendEventMock = sendEvent as jest.Mock;
const mockVideoPlayerIsAlive = videoTagIsPresent as jest.Mock;

describe(onUnhandledError, () => {
  beforeEach(() => sendEventMock.mockReset());

  it('does not send "appErrored" event when video player is present', () => {
    mockVideoPlayerIsAlive.mockImplementationOnce(() => true);

    onUnhandledError();

    expect(sendEventMock).not.toHaveBeenCalled();
  });

  it('sends "appErrored" event when video player is not present', () => {
    mockVideoPlayerIsAlive.mockImplementationOnce(() => false);

    onUnhandledError();

    expect(sendEventMock).toHaveBeenCalledWith('appErrored');
  });
});
