import type { FC } from 'react';
import { useMemo } from 'react';
import { useDynamicSettings } from 'tachyon-dynamic-settings';
import type { EventReporterRootProps } from 'tachyon-event-reporter';
import { EventReporterRoot } from 'tachyon-event-reporter';
import type { ValenceDynamicSettings } from '../../../../../config';
import { FLUME_URL, SPADE_BATCH_WINDOW_MS } from '../../../../../config';

// istanbul ignore next: trivial
export const ValenceEventReporterRoot: FC = ({ children }) => {
  const { flumeAllowedEvents, flumeAllowedProperties, spadeUrl } =
    useDynamicSettings<ValenceDynamicSettings>();

  const spadeOpts: EventReporterRootProps['spade'] = useMemo(
    () => ({ batchWindowMs: SPADE_BATCH_WINDOW_MS, spadeUrl }),
    [spadeUrl],
  );

  const flumeOpts: EventReporterRootProps['flume'] = useMemo(
    () => ({
      allowedEvents: flumeAllowedEvents,
      allowedProperties: flumeAllowedProperties,
      batchWindowMs: SPADE_BATCH_WINDOW_MS,
      flumeUrl: FLUME_URL,
    }),
    [flumeAllowedEvents, flumeAllowedProperties],
  );

  return (
    <EventReporterRoot
      children={children}
      flume={flumeOpts}
      spade={spadeOpts}
    />
  );
};

ValenceEventReporterRoot.displayName = 'ValenceEventReporterRoot';
