import type { FC } from 'react';
import { useStaticEnvironment } from 'tachyon-environment';
import { useCustomTracking } from 'tachyon-event-tracker';
import type { LatencyEvent } from 'tachyon-latency-tracker';
import { LatencyTrackerRoot } from 'tachyon-latency-tracker';
import { useRouterUtils } from 'tachyon-next-routing-utils';
import { routeNameFromPathname } from '../../../../../routing';

// istanbul ignore next: trivial
export const ValenceLatencyTrackerRoot: FC = ({ children }) => {
  const trackEvent = useCustomTracking<LatencyEvent>();
  const { currentAsPath, currentPathname } = useRouterUtils();
  const currentRouteName = routeNameFromPathname(currentPathname);
  const { client } = useStaticEnvironment();

  return (
    <LatencyTrackerRoot
      children={children}
      currentLocation={currentRouteName}
      currentPath={currentAsPath}
      onEvent={trackEvent}
      sessionID={client.sessionID}
    />
  );
};

ValenceLatencyTrackerRoot.displayName = 'ValenceLatencyTrackerRoot';
