import type { FC } from 'react';
import { RelayEnvironmentProvider } from 'react-relay/hooks';
import { useCustomTracking } from 'tachyon-event-tracker';
import type { RecordMap, RelayEvent } from 'tachyon-relay';
import { initEnvironment } from 'tachyon-relay';
import { isBrowser } from 'tachyon-utils';

type ValenceRelayEnvironmentRootProps = {
  records: RecordMap | undefined;
};

// istanbul ignore next: trivial
export const ValenceRelayEnvironmentRoot: FC<ValenceRelayEnvironmentRootProps> =
  ({ children, records }) => {
    const trackEvent = useCustomTracking<RelayEvent>();

    const relayEnvironment = initEnvironment({
      fetchQueryOpts: isBrowser() ? { onEvent: trackEvent } : undefined,
      records,
    });

    return (
      <RelayEnvironmentProvider
        children={children}
        environment={relayEnvironment}
      />
    );
  };
ValenceRelayEnvironmentRoot.displayName = 'ValenceRelayEnvironmentRoot';
