import type { DocumentInitialProps, DocumentProps } from 'next/document';
import Document, { Head, Html, Main, NextScript } from 'next/document';
import { PulsarCorePreloadWASM } from 'pulsar';
import { DarkThemeMap } from 'twitch-core-ui-tokens';

export type ValenceDocumentInitialProps = DocumentInitialProps;
export type ValenceDocumentProps = DocumentProps & ValenceDocumentInitialProps;

// this component is beginning to do webpack imports in order to enable plugins,
// which is really messing with Jest
// istanbul ignore next: not testable
/**
 * Root-level React component that is only rendered server-side, see:
 * https://nextjs.org/docs/#custom-document
 */
export class ValenceDocument extends Document<ValenceDocumentProps> {
  public render(): JSX.Element {
    return (
      <Html lang="en">
        <Head>
          <title>Twitch</title>
          <style>{`
            html, body, main {
              background-color: ${DarkThemeMap['color-background-body']};
              box-sizing: border-box;
              color: ${DarkThemeMap['color-text-base']};
              height: 100vh;
              margin: 0;
              overflow: hidden;
              padding: 0;
              width: 100vw;
            }

            main.video {
              align-items: center;
              display: flex;
              flex-direction: column;
              justify-content: center;
            }
          `}</style>
          <PulsarCorePreloadWASM />
        </Head>
        <body>
          <Main />
          <NextScript />
        </body>
      </Html>
    );
  }
}
