/*
 * EXPERIMENTAL: If the cost of maintaining these tests proves difficult, feel free to delete this file.
 *
 * These tests enable testing for invariants across all pages that cannot be expressed by the type system.
 */
import type {
  TachyonPage,
  TachyonPageContext,
  TachyonPageInitialProps,
} from 'tachyon-next-types';
// eslint-disable-next-line import/no-namespace
import * as Pages from '.';

// configure runs as a sideeffect in _app
jest.mock('./_app/configure', () => ({ configure: jest.fn() }));

function getPages(
  pages: TachyonPage[],
  filter: (page: TachyonPage) => boolean,
): [string, TachyonPage][] {
  return pages
    .filter(filter)
    .map((page) => [page.displayName ?? page.name, page]);
}

describe('.getInitialProps', () => {
  const applicablePages = getPages(
    Object.values(Pages) as TachyonPage[],
    // eslint-disable-next-line no-prototype-builtins
    (page) => page.hasOwnProperty('getInitialProps'),
  );

  /*
   * This is important so that we can use Relay's cache.
   * Unstable queryVariables returned from getInitialProps act as a cache buster.
   */
  it.each(applicablePages)(
    '%s queryVariables are stable given the same input',
    async (_displayName: string, page: TachyonPage) => {
      const ctx = {
        query: new Proxy({}, { get: () => '' }),
      } as unknown as TachyonPageContext;

      const { queryVariables: first } = (await page.getInitialProps?.(
        ctx,
      )) as TachyonPageInitialProps;
      const { queryVariables: second } = (await page.getInitialProps?.(
        ctx,
      )) as TachyonPageInitialProps;

      expect(first).toEqual(second);
    },
  );
});
