import { useEffectOnce } from 'tachyon-utils';
import type { LoadedEventData } from '../../controller';
import { useControllerContext } from '../../controller';

// istanbul ignore next: trivial
export function useOnloadMetadataEmitter(metadata: LoadedEventData): void {
  const { onLoad } = useControllerContext();

  useEffectOnce(() => {
    onLoad(metadata);
  });
}
