import type { AnalyticsEvent } from 'pulsar';
import { useCallback } from 'react';
import { useCustomTracking } from 'tachyon-event-tracker';

// istanbul ignore next: trivial
export function useTrackingEvent(): (e: AnalyticsEvent) => void {
  const trackEvent = useCustomTracking();

  return useCallback(
    ({ name: event, properties }: AnalyticsEvent) => {
      trackEvent({
        ...properties,
        event,
      });
    },
    [trackEvent],
  );
}
