import { shallow } from 'enzyme';
import NextLink from 'next/link';
import { RouteName, pathnameFromRouteName } from '../../routes';
import { TachyonLink } from '.';

// These tests use "shallow" from enzyme directly due to the complex types
describe(TachyonLink, () => {
  it('renders just an href for a static page path', () => {
    const wrapper = shallow(<TachyonLink route={RouteName.HealthCheck} />);

    const nextLink = wrapper.find(NextLink);
    expect(nextLink).toHaveProp({
      as: undefined,
      href: pathnameFromRouteName(RouteName.HealthCheck),
    });
  });

  it('renders an href and as for a static page path with query params', () => {
    const wrapper = shallow(
      <TachyonLink query={{ foo: 'bar' }} route={RouteName.HealthCheck} />,
    );

    const nextLink = wrapper.find(NextLink);
    expect(nextLink).toHaveProp({
      as: `${pathnameFromRouteName(RouteName.HealthCheck)}?foo=bar`,
      href: `${pathnameFromRouteName(RouteName.HealthCheck)}?foo=bar`,
    });
  });

  it('renders an href and as for a dynamic page path', () => {
    const wrapper = shallow(
      <TachyonLink
        route={RouteName.Channel}
        routeParams={{ login: 'therealderekt' }}
      />,
    );

    const nextLink = wrapper.find(NextLink);
    expect(nextLink).toHaveProp({
      as: '/therealderekt',
      href: pathnameFromRouteName(RouteName.Channel),
    });
  });

  it('renders an href and as for a dynamic page path with query params', () => {
    const wrapper = shallow(
      <TachyonLink
        query={{ foo: 'bar' }}
        route={RouteName.Channel}
        routeParams={{ login: 'therealderekt' }}
      />,
    );

    const nextLink = wrapper.find(NextLink);
    expect(nextLink).toHaveProp({
      as: '/therealderekt?foo=bar',
      href: `${pathnameFromRouteName(RouteName.Channel)}?foo=bar`,
    });
  });
});
