import { parse } from 'url';
import type { NextFunction, RequestHandler } from 'express';
import type {
  NextRequestHandler,
  TachyonRequest,
  TachyonRequestExtension,
  TachyonResponse,
} from 'tachyon-next-types';
import {
  createDeviceIDOnServer,
  getDeviceIDOnServer,
} from 'tachyon-server-utils';
import type { ValenceRequestExtensions } from '../../config';

export const DEBUG_PATH_PREFIX = '/_debug';

export type ServerContext = Pick<
  TachyonRequestExtension<ValenceRequestExtensions>,
  'appEnvironment' | 'dynamicSettings'
>;

export function createAppRequestHandler(
  ctx: ServerContext,
  handler: NextRequestHandler,
): RequestHandler {
  return ((
    req: TachyonRequest<ValenceRequestExtensions>,
    res: TachyonResponse,
    _next: NextFunction,
  ): void => {
    if (process.env.NODE_ENV !== 'test') {
      console.log(`# Handling request for ${req.path}`);
    }

    // generate device ids for local dev
    if (
      process.env.NODE_ENV !== 'production' &&
      process.env.NODE_ENV !== 'test'
    ) {
      if (!getDeviceIDOnServer(req, res)) {
        createDeviceIDOnServer(res);
      }
    }

    req.tachyon = ctx;

    handler(req, res, parse(req.url, true));
    // cast to narrow back down to express types
  }) as any as RequestHandler;
}
