module.exports = ({
  envConfig = {},
  isTest = false,
  plugins = [],
  presets = [],
  runtimeConfig = {},
}) => {
  presets = [
    ['@babel/preset-env', { loose: true, ...envConfig }],
    ['@babel/preset-react', { runtime: 'automatic' }],
    ['@babel/preset-typescript', { onlyRemoveTypeImports: true }],
  ].concat(presets);

  plugins = [
    [
      'babel-plugin-styled-components',
      // disable displayName and ssr in tests
      { displayName: !isTest, fileName: false, pure: true, ssr: !isTest },
    ],
    ['@babel/plugin-transform-runtime', { ...runtimeConfig }],
  ].concat(plugins);

  return {
    plugins,
    presets,
  };
};
