const {
  utils: { getPackages },
} = require('@commitlint/config-lerna-scopes');

module.exports = {
  extends: ['@commitlint/config-conventional'],
  rules: {
    'body-empty': [2, 'always'],
    'footer-empty': [2, 'always'],
    'header-min-length': [2, 'always', 15],
    'scope-empty': [2, 'never'],
    'scope-enum': (ctx) =>
      getTachyonScopes(ctx).then((packages) => [2, 'always', packages]),
  },
};

const getTachyonScopes = (context) =>
  // customize the default rule for readability and ergonomics
  getPackages(context).then((packages) => {
    const tachyonScopes = packages.map((package) =>
      package.replace(/^tachyon-/, ''),
    );
    tachyonScopes.sort();
    // add catch-all 'repo' for more general work, allowing for mandatory scopes
    tachyonScopes.unshift('repo');
    // add native apps manually so we don't have to create package.json for them that might complicate build processes
    tachyonScopes.unshift('androidtv-native-app');
    tachyonScopes.unshift('nintendo-switch-native-app');
    tachyonScopes.unshift('playstation-native-app');
    return tachyonScopes;
  });
