import type { FC } from 'react';
import { useEffect } from 'react';
import ReactDOM from 'react-dom';
import schema from './schema/schema.json'; // eslint-disable-line import/no-internal-modules
import { clientId } from './twitch-relay.config';

const config = {
  extensions: {
    // order matters for these
    /* eslint-disable sort-keys-fix/sort-keys-fix */
    endpoints: {
      sandbox: {
        headers: {
          'Client-Id': clientId,
        },
        url: 'https://graphql.twitch.a2z.com/master/gql',
      },
      prod: {
        headers: {
          'Client-Id': clientId,
        },
        schema,
        url: 'https://gql.twitch.tv/gql/',
      },
      appeals: {
        headers: {
          'Client-Id': '1t8ink24g3pvtp2cs75qn1vxuk001t',
        },
        url: 'https://appealsedge.service.safety.twitch.a2z.com/internal/graphql/',
      },
      /* eslint-enable sort-keys-fix/sort-keys-fix */
    },
  },
};

const GqlPlayground: FC = () => {
  useEffect(() => {
    (window as any).GraphQLPlayground.init(
      document.getElementById('playground'),
      {
        config,
        endpoint: 'sandbox',
      },
    );
  }, []);

  return <div id="playground" />;
};
GqlPlayground.displayName = 'GqlPlayground';

ReactDOM.render(<GqlPlayground />, document.getElementById('root'));
