# Glossary of Terms

It is necessary to have clear and precise language when communicating. Some
terms of art in software engineering fail at that and end up with local
definitions, this glossary attempts to bridge that issue.

<dl>
<dt>Build</dt> <dd>Building an application refers to performing whatever steps are necessary to make an executable artifact of the source.</dd>
<dt>Client-Side Application</dt> <dd>The application, or part of the application, that runs on the client (see server-side application, universal application).</dd>
<dt>Continuous Deployment (CD)</dt> <dd>This builds upon CI but deploys each new version of the application to some environment. This can sometimes mean a production environment though that is occasionally referred to as Continuous Delivery but that term hasn’t been used at Twitch.</dd>
<dt>Continuous Integration (CI)</dt> <dd>Continuously integrating and building versions of the application upon each change. This doesn’t necessarily imply testing in all cases, but does for Tachyon apps.</dd>
<dt>Deploy</dt> <dd>Introducing a version of the application to a new environment. Example: We deployed that version to a staging environment for Ensemble, once they’ve approved it we’ll deploy it to LG’s QA environment.</dd>
<dt>Distribute</dt> <dd>Provide released applications to the end user. The application might be distributed through an app store or it might be distributed through a Content Distribution
Network (CDN) if it is a web application.</dd>
<dt>Doc Portal</dt> <dd>The Tachyon-based doc portal at which you are currently looking (aka Tachyon Wiki, Tachyon Doc Portal)</dd>
<dt>Doc Repository</dt> <dd>The <a href="https://drive.google.com/drive/folders/1l8oVg_1UiBvn2QdFLxAhRUStYwp2X6Ch">Emerging Platforms Engineering Docs folder in Google Drive</a>.</dd>
<dt>Hybrid Application</dt> <dd>An application that consists of both a native application component and a web application component.</dd>
<dt>Release</dt> <dd>Making a version of an application or feature available to the end user. Example: We released the new version to Vestel. </dd>
<dt>Resident Application</dt> <dd>An application residing on the device vs. one fetched from the internet. An example of this is Laser Array (resident) vs Starshot (not).</dd>
<dt>Server-Side Application</dt> <dd>The application, or part of the application, that runs on the server (see client-side application, universal application).</dd>
<dt>Universal Application</dt> <dd>An application that executes on the server then serializes its start into a server response so that it can resume execution on the client.</dd>
</dl>
