# Tachyon Repo Configuration

## Local dev port usage

For the main Next apps, their local dev ports are abstracted by nginx's reverse
proxy functionality, but we track their usage here to avoid conflicts as the
repo evolves.

### Next-based Apps

- Moonbase: 3400
- SkyMap: 3010
- Starshot: 3100
- Tomorrow: 3200
- Valence: 3300

In production, all apps run on port 3003.

### CRA-based examples and others

- GQL Playground: 3011
- Prototyper: 3012
- Pulsar Core example: 3020
- Twitch Chat Client example: 3021
- Valence example / test harness: 3301
- Moonbase local graphql: 3401

The 301x range is used for repo utilities, while 3020+ is used for examples that
require unique ports (usually for HTTPS purposes). Valence is special-cased to
align with its parent app. All other CRA-based apps use the default port 3000
until they devleop the need for special requirements.
