# Chromium Notes

Last version of Chrome 53:
[53.0.2785.143](https://chromereleases.googleblog.com/2016/09/stable-channel-update-for-desktop_29.html)
Last version of Chrome 38:
[38.0.2125.122](https://chromereleases.googleblog.com/2014/11/stable-channel-update.html)

## Downloading old Chromium builds

[Follow these instructions](https://www.chromium.org/getting-involved/download-chromium)
to get old builds. Note that these won't have proprietary codecs enabled.

## Building Chromium

Follow the
[building Chromium](https://chromium.googlesource.com/chromium/src/+/master/docs/mac_build_instructions.md)
guide to attempt to build modern Chromium first to ensure basic functionality.

If you see the following error:

```
xcode-select: error: tool 'xcodebuild' requires Xcode, but active developer directory '/Library/Developer/CommandLineTools' is a command line tools instance
```

then you need to run the following command:

```
sudo xcode-select -s /Applications/Xcode.app/Contents/Developer
```

Use the
[NOSYNC build settings](https://github.com/henrypp/chromium/blob/master/args_gn.md)
(no google apis) in `args.gn`.

More info about GN:
[Overview of GN](https://www.chromium.org/developers/gn-build-configuration)
[GN Quick Start](https://gn.googlesource.com/gn/+/master/docs/quick_start.md)
[List of all GN args](https://gitlab.com/noencoding/OS-X-Chromium-with-proprietary-codecs/-/wikis/List-of-all-gn-arguments-for-Chromium-build)

## Building Older Chrome

_Note: It appears that the 3rd-party git submodules that Chrome from 2014 (38)
and 2016 (53) may have gone stale. This presents during the `gclient sync` step
in older checkouts._

Building older versions:
[General info for building older versions](https://chromium.googlesource.com/chromium/src/+/master/docs/building_old_revisions.md)
[Disabling depot_tools auto-update](https://dev.chromium.org/developers/how-tos/depottools#TOC-Disabling-auto-update)

All of the released builds are tagged, so check out the commit at the desired
version.

Google maintains a vendoring/prebuild repositories for many of their
dependencies, and these repos are referenced during the setup phase
(`gclient sync`) which downloads specific SHAs of these dependencies.
Unfortunately, some of these SHAs reference version specific branches that are
no longer available, meaning their SHAs are not available via `git` and thus we
have to replace them manually.

### Chrome 38

#### Running `gclient sync`

In `.DEPS.git`:

- change
  [`/native_client/src/native_client/tests/prebuilt.git@e65f794ce4a809d92d5cacae55ae119946bdb9c5`](https://chromium.googlesource.com/native_client/src/native_client/tests/prebuilt/+/e65f794ce4a809d92d5cacae55ae119946bdb9c5)
  to
  [`/native_client/src/native_client/tests/prebuilt.git@3e17365176c94624f46cace174f61834b7f3c35d`](https://chromium.googlesource.com/native_client/src/native_client/tests/prebuilt/+/3e17365176c94624f46cace174f61834b7f3c35d)
- change
  [`/native_client/src/native_client.git@e1ee9bde16edeb4b20e796a014c9877e65566da2`](https://chromium.googlesource.com/native_client/src/native_client/+/e1ee9bde16edeb4b20e796a014c9877e65566da2)
  to
  [`/native_client/src/native_client.git@12d825e5b0f5665be3796b10d6c5e1c598445f4b`](https://chromium.googlesource.com/native_client/src/native_client/+/12d825e5b0f5665be3796b10d6c5e1c598445f4b)
- change
  [`/external/google-breakpad/src.git@4c5fcfd85bf658e45258c6d263a6080f2e5cf0f2`](https://chromium.googlesource.com/external/google-breakpad/src/+/4c5fcfd85bf658e45258c6d263a6080f2e5cf0f2)
  to
  [`/external/google-breakpad/src.git@01f3438079e9e1e3e01fce7f4d19ec47bb75fda8`](https://chromium.googlesource.com/external/google-breakpad/src/+/01f3438079e9e1e3e01fce7f4d19ec47bb75fda8)
- change
  [`/external/libaddressinput.git@5e0f1290b83e59c0b3b0b3d23c060f1b134a1364`](https://chromium.googlesource.com/external/libaddressinput/)
  to
  [`/external/libaddressinput.git@012be95876718c9e200a5387ff78546364d27a70`](https://chromium.googlesource.com/external/libaddressinput/+/012be95876718c9e200a5387ff78546364d27a70)
- change
  [`/chromium/deps/libvpx.git@8110782824f708dd3630cd55375019648567c31c`](https://chromium.googlesource.com/chromium/deps/libvpx/+/8110782824f708dd3630cd55375019648567c31c)
  to
  [`/chromium/deps/libvpx.git@0f393e92b0e220eeaa6acb0ad31e696fa5c67ccd`](https://chromium.googlesource.com/chromium/deps/libvpx/+/0f393e92b0e220eeaa6acb0ad31e696fa5c67ccd)
- change
  [`/chromium/deps/opus.git@cae696156f1e60006e39821e79a1811ae1933c69`](https://chromium.googlesource.com/chromium/deps/opus/)
  to
  [`/chromium/deps/opus.git@ecd910518a67b46a307494a9b8ba7e06c9ab4508`](https://chromium.googlesource.com/chromium/deps/opus/+/ecd910518a67b46a307494a9b8ba7e06c9ab4508)
- change
  [`/external/trace-viewer.git@5f89b7cd5732ddf7e783bb6c9fe57bb8a7cf74e2`](https://chromium.googlesource.com/external/trace-viewer/)
  to
  [`/external/trace-viewer.git@4fce8731e0ce1bbbd7fd64ddafd9c474d6e8c63e`](https://chromium.googlesource.com/external/trace-viewer/+/4fce8731e0ce1bbbd7fd64ddafd9c474d6e8c63e)
- change
  [`/external/webrtc/trunk/webrtc.git@a6ed0dfa13f606d7f173f740510c2ed5855aa7fd`](https://chromium.googlesource.com/external/webrtc/trunk/webrtc/+/a6ed0dfa13f606d7f173f740510c2ed5855aa7fd)
  to
  [`/external/webrtc/trunk/webrtc.git@40f530adb74dba8097d9e7b746fa919ce1d66039`](https://chromium.googlesource.com/external/webrtc/trunk/webrtc/+/40f530adb74dba8097d9e7b746fa919ce1d66039)
- change
  [`/external/v8.git@d71adf709268b5bfd5d67faf97429b23c2948354`](https://chromium.googlesource.com/external/v8/+/d71adf709268b5bfd5d67faf97429b23c2948354)
  to
  [`/external/v8.git@cb1b554a837bb47ec718c1542d462cb2ac2aa0fd`](https://chromium.googlesource.com/external/v8/+/cb1b554a837bb47ec718c1542d462cb2ac2aa0fd)
- change
  [`'webkit_rev':'@1493aa587a0f52182dcb7830a55528bf0b92af9f'`](https://chromium.googlesource.com/chromium/blink/+/1493aa587a0f52182dcb7830a55528bf0b92af9f)
  to
  [`'webkit_rev':'@20a3bc73c6aeac3f5846faa54b166501a1909d43'`](https://chromium.googlesource.com/chromium/blink/+/20a3bc73c6aeac3f5846faa54b166501a1909d43)
- change
  [`/external/w3c/csswg-test.git@f9b9daa33eac525923e941333d389fcb42f9b19f`](https://chromium.googlesource.com/external/w3c/csswg-test/)
  to
  [`/external/w3c/csswg-test.git@ee7da9ecb3c8683e7f5167d087cb3bbc42b84100`](https://chromium.googlesource.com/external/w3c/csswg-test/+/ee7da9ecb3c8683e7f5167d087cb3bbc42b84100)
- change
  [`/external/w3c/web-platform-tests.git@6c7bd34e408ff69687a95d75b7e562fa84148997`](https://chromium.googlesource.com/external/w3c/web-platform-tests/)
  to
  [`/external/w3c/web-platform-tests.git@fc8b45365f6fa1de22fed3a0bcf729d84ff9340d`](https://chromium.googlesource.com/external/w3c/web-platform-tests/+/fc8b45365f6fa1de22fed3a0bcf729d84ff9340d)

### Chrome 53

In `DEPS`, update the SHA for `webrtc/trunk/webrtc` from
[19ef428c81f230a1c809cf42089ba7e00051d0a0](https://chromium.googlesource.com/external/webrtc/trunk/webrtc/+log/19ef428c81f230a1c809cf42089ba7e00051d0a0)
(which is from the 53 branch) to
[8b8ab57733688cfb5cc3f78a0e6a2e3ee1f1d33c](https://chromium.googlesource.com/external/webrtc/trunk/webrtc/+/8b8ab57733688cfb5cc3f78a0e6a2e3ee1f1d33c)

## Cross-compiling

For cross-compiling:
[Add relevant target info](https://gn.googlesource.com/gn/+/master/docs/cross_compiles.md)
in `args.gn`.
