# Deploying Starshot

## Environment Management For App Store Distributed Starshot

In some cases, Starshot is distributed through app stores which technically gate
changes with manufacturer-owned QA passes. We do not update these environments
with the latest main as we would a typical web-app. Instead, we follow an
LTS-style release strategy allowing for back-end/non-visual updates and
hot-fixes while preserving the UI/UX state and behavior until the next QA
submission.

Each environment that serves app store distributed Starshot is tied to a
specific branch, and attempted deploys of other branches (including main) to
that environment will fail.

## Environments

| Name                                                                                                                                                   | Deploy Branch | Notes                                                                                                                                                        |
| ------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| [LG QA](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_StarshotLGQADeploy?branch=lg_qa)                                        | lg_qa         | Used for submitting new release candidates to LG. Temporarily serves production traffic when the candidate is released to the App Store after QA acceptance. |
| [LG Production](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_StarshotLGProductionDeploy?branch=lg&buildTypeTab=overview)     | lg            | Handles the majority of traffic during the life of a released version.                                                                                       |
| [Roku](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_StarshotRokuProductionDeploy?branch=%3Cdefault%3E&buildTypeTab=overview) | main          | Currently used for integration testing by various manufacturers.                                                                                             |
| [TV Web](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_StarshotWebDeploy?branch=%3Cdefault%3E&buildTypeTab=overview)          | main          | Serves traffic to tv.twitch.tv.                                                                                                                              |

### Prepping a QA Submission Deploy

More details about the mechanics of preparing an environment for QA submission
can be found in the [QA-through-Production workflow](./qa-through-prod.md).

## Deploying to Production

In general, follow the same processes as
[Tomorrow](../tomorrow/deploying-tomorrow.md), except you'll need to manually
select the correct branch via the TC task kebab menu instead of pressing the
"Deploy" button (pending further refinement of the TC setup).

An example workflow:

1. Deploy the `<manufacturer>` branch to a staging environment:
   1. In TC, go to
      [Tachyon Staging > Deploy App to Environment](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_StagingDeployApptoEnvironment#all-projects)
   1. Click the kebab button next to the 'Deploy' button. A modal will open.
   1. In the modal, navigate to the 'Changes' tab and select `<manufacturer>` as
      the 'Build branch'
   1. In the modal, navigate to the 'Parameters' tab and select any value
      (example: `fix7y1uvk4b1ahet92bx`) as the 'Tachyon Staging Slot' and select
      `starshot` as the 'Tachyon App'.
   1. Click the 'Run Build' button to dismiss the modal.
1. Verify video playback manually on TVs with Chromium 38 and Chromium 53 (2017
   and 2019 LG TVs, respectively).
1. Deploy the `<manufacturer>` branch to the <manufacturer> release environment:
   1. Announce the deploy in the #emp-deploys and #site-production Slack
      channels
   1. In TC, go to
      [Starshot Production > <manufacturer> Production Deploy](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_StarshotLGProductionDeploy#all-projects)
   1. Click the kebab button next to the 'Deploy' button. A modal will open.
   1. In the modal, navigate to the 'Changes' tab and select `<manufacturer>` as
      the 'Build branch'
   1. Click the 'Run Build' button to dismiss the modal.
   1. Confirm the expected build id (commit sha for the branch tip) shows on the
      [Settings Page](https://lzfnhhvpeppznbnngsio.tv.twitch.tv/settings)

## Prepping a hot-fix deploy

1. Follow the [hot-fix process](./hotfixes.md) for the `<manufacturer>` branch
1. Follow the standard deploy process for the `<manufacturer>` branch

## Rollbacks

1. Reset the `<manufacturer>` branch to the desired rollback point
   ```sh
     git tag -l sst_<manufacturer>_deploy*
     git checkout <tag to rollback to>
     git push lg --force
   ```
1. Follow the standard deploy process for the `<manufacturer>` branch
