# Performing Starshot Hot-Fixes

## Context

The majority of hot-fixes will be developed in `main`, since they will be
relevant going forward and thus should be included in future versions. In order
to maintain UI/UX consistency within a version of the app, we cannot just deploy
the equivalent of `main` though, and instead will need to cherry-pick the
relevant commits onto the relevant `<manufacturer>` branch (or branches),
allowing for a transparent update.

Usually this should be a seamless process, but occasionally the cherry-pick will
need to be modified to work with the older "frozen" state of the repo. In
worst-case scenarios it may be necessary to re-implement the relevant changes
from scratch directly on top of the relevant `<manufacturer>` branch (or
branches).

## Steps

To perform a hot fix or add an outside-of-QA commit:

1. Create a PR for you changes
1. Merge the PR into the `<manufacturer>` branch

Note: we do not force push. This callout is important, because we want to make
sure a hotfix or other outside-of-QA commit does not accidentally wipe away any
existing hotfixes / commits.
