# Manufacturer Mappings

| Target       | Latest Release URL                           | ECS Cluster                                                                                                                                   | Log Group                                                                                                                                                                | Platform      | Git Branch |
| ------------ | -------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------- | ---------- |
| LG           | https://mibnwrctglhhkgb3.lg.tv.twitch.tv     | [starshot_lkzs92r230i7zisfd421y](https://us-west-2.console.aws.amazon.com/ecs/v2/clusters/starshot/services/starshot_lkzs92r230i7zisfd421y)   | [starshot_lkzs92r230i7zisfd421y](https://us-west-2.console.aws.amazon.com/cloudwatch/home#logsV2:log-groups/log-group/starshot_lkzs92r230i7zisfd421y)                    | lg_web_tv     | lg         |
| LG QA        | https://qabrodbryyhfpgeg.lg.tv.twitch.tv     | [starshot_lq8cyqoeb1rtetuux1bx7c](https://us-west-2.console.aws.amazon.com/ecs/v2/clusters/starshot/services/starshot_lq8cyqoeb1rtetuux1bx7c) | [starshot_lq8cyqoeb1rtetuux1bx7c](https://us-west-2.console.aws.amazon.com/cloudwatch/home#logsV2:log-groups/log-group/starshot_lq8cyqoeb1rtetuux1bx7c)                  | lg_web_tv     | lg_qa      |
| Vestel       | https://lifonkblzxzuckp1.vestel.tv.twitch.tv | [starshot_rq1gqpr82diiadnih9k64m](https://us-west-2.console.aws.amazon.com/ecs/v2/clusters/starshot/services/starshot_rq1gqpr82diiadnih9k64m) | [starshot_rq1gqpr82diiadnih9k64m](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logsV2:log-groups/log-group/starshot_rq1gqpr82diiadnih9k64m) | vestel_web_tv | vestel     |
| tv.twitch.tv | https://tv.twitch.tv                         | [starshot_7n44uwlq7reik5rwn7ld](https://us-west-2.console.aws.amazon.com/ecs/v2/clusters/starshot/services/starshot_7n44uwlq7reik5rwn7ld)     | [starshot_7n44uwlq7reik5rwn7ld](https://us-west-2.console.aws.amazon.com/cloudwatch/home#logsV2:log-groups/log-group/starshot_7n44uwlq7reik5rwn7ld)                      | web_tv        | main       |

## URL History

This records the history of URLs associated with releases of the Starshot app
for various manufacturers.

### URL schemes

The URL "versions" are associated with the submissions or revisions for each
manufacturer, decoupled from the concept of versions associated with Starshot
itself. This allows us to accommodate a wide range of validation and version
promotion strategies while maintaining a degree of quick human
understandability.

Each URL starts with a random string of 15 characters, preferably starting with
a sequence that is somewhat pronounceable
([datatype.org's string generator](https://www.datatype.org/strings/) can be
super useful for this). It is then followed by the number representing that
manufacturer's revision (which then increases linearly).

### LG

#### Production URLs

| Version | URL                                       | Laser-Array Build Commit / Date | Client App  | Pageview Location |
| ------- | ----------------------------------------- | ------------------------------- | ----------- | ----------------- |
| 1       | https://lzfnhhvpeppznbnngsio.tv.twitch.tv |                                 | starshot    | "loader"          |
| 2       | https://ushbsamruavydrm2.lg.tv.twitch.tv  | aa00830 (Aug 14 2020)           | laser-array | "loader"          |
| 3       | https://mibnwrctglhhkgb3.lg.tv.twitch.tv  | 8d0d606 & a21faee (Dec 18 2020) | laser-array | "loader"          |

The first URL is from before the current URL management scheme was formalized,
and we maintain it to ensure access for any clients who somehow haven't updated.
Otherwise, the Production service catches any `https://\*.lg.tv.twitch.tv` URLs
that are not explicitly assigned to QA stack.

#### Persistent QA URL

This URL always points to the LG QA stack:

- https://qabrodbryyhfpgeg.lg.tv.twitch.tv

### Vestel

#### Production URLs

1. https://lifonkblzxzuckp1.vestel.tv.twitch.tv

The Vestel Production service catches all `https://\*.vestel.tv.twitch.tv` URLs.

#### QA

Vestel does not have a dedicated QA stack and utilizes common public previews
for verification.
