# Platforms

## Targeting New Platforms

There are several steps to successfully having Starshot run on a new platform.

### Metrics

A new platform value needs to be added to the `Platform` enum in the
[`tachyon-environment` package](https://git.xarth.tv/emerging-platforms/tachyon/blob/main/packages/tachyon-core/environment/src/Platform.ts).
The new platform name must adhere to the following rules:

- must contain "web" somewhere in it (due to IVS/PlayerCore constraints)
- must end in "\_tv" (due to Recs service constraints)

Thus you'll see that all starshot platforms follow the `[foo]_web_tv` pattern.

To ensure this value is properly set, have the deploy task set the
`tachyon.platform` build environment parameter, which will populate the correct
environment variable in the container runtime, which will get picked up by the
node web server and passed into the Next application.

### Ads

To ensure that the ads service properly attributes impressions to the correct
platform, the
[Fring ads service](https://git.xarth.tv/ads/fring/blob/master/adcustomparams/helpers.go)
needs to be updated. Add the new mapping entry to the
`platformToAdServerPlatformMap` map, and add a matching test.

## Mocking A Platform Value For Local Development

Begin your session with `TACHYON_PLATFORM=[foo]_web_tv yarn start` to run
Starshot locally with a specific platform value. This is useful for developing
platform-specific app behavior.
