# Starshot QA-through-Production Workflow

There are 2 versions of this workflow, but only one is currently in use.

## Manufacturer-driven App Store Releases

For manufacturers that control the release of new versions via their own App
Stores, we have a specific async QA-to-Production cutover process to accommodate
them. This currently applies to the following manufacturers:

- LG
- Vestel

### Prepping the QA Environment

Before we submit to QA, we must scale up the QA infrastructure. This is
accomplished by changing the instance count for the deployed regions from 3 to 6
(controlled via the associated `updateRegion` calls in `settings.kts`). This
change should be made and merged into main before the QA branch is updated in
order to prevent accidental downscaling via hotfixes, additional QA submissions,
etc. It is important to scale up the infrastructure because the QA stack will
serve production traffic for a short period after the new app version is
released on the App Store and promoted to customers.

### Creating a new version URL

Each new version of the app needs a corresponding URL so that the QA promotion
process has a stable reference. We choose a new subdomain string with the
following criteria:

- Starts with 15 random letters, all lower-case
- Ideally the first 3-4 letters form a pronounceable sequence, making it easier
  for the team to refer to it in conversation
- Ends with a number representing the corresponding version of the app (we count
  every release as a "major" release for this purpose)

For example, you might choose something like `ushbsamruavydrm2` for the second
release of an app. See the
[URL version history](./manufacturer-mappings.md#url-history) for more
reference.

Once you have your subdomain string, follow the docs on
[creating a new release URL for the QA stack via the Fastly dashboard](https://wiki.twitch.com/pages/viewpage.action?spaceKey=PS&title=How+to+create+new+LG+URLS+in+Fastly).

1. Verify your new URL reaches the QA stack
1. Update [manufacturer mappings](./manufacturer-mappings.md) tables and the URL
   version history.
1. Add it to the [URL version history](./url-history.md).
1. Add the URL to src/domainList.ts
1. Add the URL to the appropriate build script (webos/scripts/build-tv-webos)

### Deploying to QA

Once Starshot has reached the point where it is ready for submission to the
manufacturer's QA process, reset the `<manufacturer>_qa` branch to the approved
commit in the main branch (almost always HEAD):

1. Go to Tachyon's
   [branch rules](https://git.xarth.tv/emerging-platforms/tachyon/settings/branches).
1. Press "Edit" on the manufacturer branch configuration that will need to be
   reset.
1. Temporarily enable "Allow force pushes".
1. Run the commands below.
1. Disable "Allow force pushes".

```sh
git checkout <manufacturer>_qa
git reset --hard HEAD
git push origin <manufacturer>_qa
```

We hard reset instead of merging because we don't care about the history of the
QA branch (and in fact want to discard any hotfixes that may exist on it) and
are more concerned about having a stable pointer to the released commit in the
main branch. Once the QA branch is running the correct version, deploy it to the
corresponding QA environment via TeamCity.

### Deploying to Production after an App Store Release

Once a new Starshot version has passed QA and been released onto the app store,
the QA stack should now be serving most, if not all, user traffic (since they
will now be targeting the newly created URL). Use the
[release adoption](https://app.mode.com/twitch/reports/40cc98aede00) report to
confirm this.

To prepare for moving the user traffic back to the Production infra, we hard
reset the `<manufacturer>` branch to the `<manufacturer>_qa` branch so that it
is at the exact version that passed QA plus any hotfixes that were applied
post-promotion (again we don't need history but rather just stable version
management). Follow the same process as resetting the qa branch outlined above.
After verifying that the versions match, deploy the `<manufacturer>` branch to
the corresponding Production environment via TeamCity.

### Cutting over Traffic

Once the idle Production stack is running the same app version as the hot QA
stack, we are ready to perform a cutover. This is performed by removing the
recently-created URL from the QA stack, following the docs on
[removing a release URL from the QA stack via the Fastly dashboard](https://wiki.twitch.com/pages/viewpage.action?spaceKey=PS&title=How+to+create+new+LG+URLS+in+Fastly).
This will cause Fastly to send requests for that URL to the Production stack
because it is running a wildcard matcher for manufacturer-specific subdomain
path. This means that all past URLs (and random unassigned ones too) will
resolve to the Production stack.

### Downscaling QA

Once traffic has fully reverted to the Production stack, we can downscale the QA
infrastructure to its base level. This is accomplished by changing the instance
count for the deployed regions from 6 to 3 (controlled via the associated
`updateRegion` calls in `settings.kts`). Note that 3 is the minimum because it
is the lowest count that fills the availability zones in each region.

## Twitch-driven Production Releases

This strategy is not currently in use and will be expanded when it becomes
relevant.
