# Starshot URL History

This records the history of URLs associated with releases of the Starshot app
for various manufacturers.

## URL schemes

The URL "versions" are associated with the submissions or revisions for each
manufacturer, decoupled from the concept of versions associated with Starshot
itself. This allows us to accommodate a wide range of validation and version
promotion strategies while maintaining a degree of quick human
understandability.

Each URL starts with a random string of 15 characters, preferably starting with
a sequence that is somewhat pronounceable
([datatype.org's string generator](https://www.datatype.org/strings/) can be
super useful for this). It is then followed by the number representing that
manufacturer's revision (which then increases linearly).

## LG

### Production URLs

1. https://lzfnhhvpeppznbnngsio.tv.twitch.tv
2. https://ushbsamruavydrm2.lg.tv.twitch.tv
3. https://mibnwrctglhhkgb3.lg.tv.twitch.tv
4. https://coyhhqjzbvbinjy4.lg.tv.twitch.tv

The first URL is from before the current URL management scheme was formalized,
and we maintain it to ensure access for any clients who somehow haven't updated.
Otherwise, the Production service catches any `https://\*.lg.tv.twitch.tv` URLs
that are not explicitly assigned to QA stack.

### Persistent QA URL

This URL always points to the LG QA stack:

- https://qabrodbryyhfpgeg.lg.tv.twitch.tv

## Vestel

### Production URLs

1. https://lifonkblzxzuckp1.vestel.tv.twitch.tv

The Vestel Production service catches all `https://\*.vestel.tv.twitch.tv` URLs.

### QA

Vestel does not have a dedicated QA stack and utilizes common public previews
for verification.

## Switch

### Production URLs

1. https://mrohkkcptggjkje1.switch.tv.twitch.tv

The Switch Production service catches all `https://\*.switch.tv.twitch.tv` URLs.

### QA

Switch does not have a dedicated QA stack and utilizes common public previews
for verification.
