# Deploying Tomorrow

This document outlines how to perform a production deployment of Tomorrow
through TeamCity. This involves creating a Change Request (CR), performing a
final main QA verification, and finally kicking off the deploy.

**NOTE:** During a **SEV-1** announced in `#site-production` OR `#emergency` you
**MUST DEFER or ROLLBACK any deploys.**

## Prerequisites

Ensure that you can:

- Access twitch-cpe+mweb as Maintainer from Isengard.

- Access all of the [logs and metrics](./logs-and-metrics.md) dashboards

- Access Tomorrow's
  [Full Deploy Job](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_TomorrowFullDeploy)

## The Deploy Process

### Step 1: Create A Change Request (CR) Ticket

1. Create a
   [Change Request](https://jira.twitch.com/secure/CreateIssueDetails!init.jspa?pid=16601&issuetype=15301).

1. Adhere to the
   [P&S Production Change Standards](https://wiki.twitch.com/pages/viewpage.action?pageId=205886531)
   in creating the CR and set the risk according to the guidelines.

1. For "Description" summarize the major changes in the
   [Tomorrow "Full Deploy" Pending Changes list](https://teamcity.xarth.tv/viewType.html?buildTypeId=EmergingPlatforms_Tachyon_TomorrowFullDeploy&tab=pendingChangesDiv&branch_EmergingPlatforms_Tachyon_TomorrowProduction=%3Cdefault%3E&from=&to=&userId=&path=&comment=&revision=&showBuilds=false&showChangesFromDependencies=false&changesLimit=1).

1. For "Sprint" add to our current sprint for increased visibility.

1. For "Deployment Plan" put "1% Canary for 30 minutes, then 100%".

1. For "Rollback Plan" put "Instant rollback via TeamCity".

1. For "Change Start/End" set a reasonable window that includes time for
   validation, CR approval, and the 30 minute canary process. i.e. 1 hour.

1. For "Evidence of Testing" put "Tested on main staging." For more
   complicated/higher risk changes, explain what was done.

1. For "Approver" set Matt Follet (follem), Risto or Derek (SDE III's) may also
   approve CR's as a fallback.

1. Get approval from whomever you set.

### Step 2: Perform Final Main Verification

Ensure that the main staging environment is up to date
[here](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_StagingTomorrowMainStaging).

1. **FOR ALL CHANGES** visit the
   [main staging environment](https://master.mweb-staging.xarth.tv) on iOS 10.3
   and validate any major changes for all critical flows. Repeat the same
   process with JavaScript turned off to ensure that server rendering is working
   as expected.

1. For new features or major layout changes, use an iPhone Xs Max device in the
   simulator in landscape to test safe inset padding for critical flows.

**Critical Flows:**

- Homepage -> Channel -> Video Playback

- Offline Channel -> Channel Profile renders in place

- Games -> Game -> Channel

- Search -> Channel

### Step 3: Open Dashboards For Monitoring The Deploy

Open relevant real-time [dashboards](./logs-and-metrics.md) to ensure you have
visibility into the health of the deploy.

### Step 4: Start A Production Deploy

Deploy Overview:

- When a deploy is started, main is promoted to canary for 30 minutes. Canary
  always receives 1% of Tomorrow traffic.

- At the 30 minute mark, main (at the time of the deploy) is promoted to the
  production environment (the other 99% of users)

Performing The Deploy:

1. Go to the
   [Tomorrow Production "Full Deploy"](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_TomorrowFullDeploy?branch=%3Cdefault%3E&buildTypeTab=overview#all-projects)
   and click "Deploy" under "Deploy to Production Environment".

1. Ensure that the "Parameters" tab "Minutes to Delay after Canary Deploy" value
   is 30 minutes (this value should not be changed without strong
   justification).

1. Under the "Changes" tab, ensure that "Build branch" is set to "Default
   branch".

1. Click "Run Build" to start.

1. In #emp-deploys post `Deploying Mobile Web to production: <CR-JIRA-link>.`.

1. Cross-post this message to #site-production:
   `!xpost #site-production slack-msg-link`. You should see a message confirming
   this action worked.

1. Check #emp-deploys for the following messages: notifications in #emp-deploys
   `Running` and

   1. Running - Canary Deploy
   1. Succeeded - Canary Deploy
   1. Running - Full Deploy (delays for 30 minutes before doing the deployment)

1. During the 30-minute delay between canary and production deployments, monitor
   for any issues. If PagerDuty alerts in this window roll back immediately.

### Step 5: Validate The Completed Deploy

1. Ensure that a `Succeeded - Full Deploy` message posted in #emp-deploys.

1. Check our client-side error logs in
   [Sentry](https://sentry.io/organizations/twitch/issues/?environment=production&project=5214452)
   to ensure that no new major errors have been introduced and rates for
   existing errors still look reasonable.

1. Check real-time [dashboards](./logs-and-metrics.md) one final time to ensure
   no new oddities have occurred.

1. Mark the Change Request as complete by pressing the "Close" button in the
   JIRA ticket action bar.

## Other Deploy Processes

### Deploying Only To Canary

1. Create a
   [Change Request](https://jira.twitch.com/secure/CreateIssueDetails!init.jspa?pid=16601&issuetype=15301).
   Please adhere to the
   [Clients Change Management Process](https://docs.google.com/document/d/1s7DzW-vY1DlbE3vgh9EY14s41sSYqO4s_hJhcoo4r-Y/edit)
   in creating the CR and set the risk according to the guidelines.

1. To deploy only to the production canary, go to the
   [Tomorrow "Canary Deploy" Page](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_TomorrowCanaryDeploy?branch=%3Cdefault%3E&buildTypeTab=overview)
   and click "Deploy" under "Deploy Canary to Production Environment".

1. This will immediately kick off a deploy of latest main. Use the ellipsis menu
   to see more options.

### Roll Backs

#### Rolling Back During The Canary Period

If a canary has been deployed and you are in the production delay period:

1. Cancel the deploy job.

1. Follow the steps below to rollback to a previous build. While you could
   technically redeploy only the canary, it is safer (and costless) to do a full
   redeploy of the previous version.

#### Rolling Back A Completed Deploy

1. To rollback a production deploy, go to the
   [Tomorrow "Full Deploy" page](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_TomorrowFullDeploy)
   and click "Success" next to the target hash of the version which you want to
   roll back to (takes you to the summary page for that build).

1. In the top right of the build summary page, select the "Actions" dropdown and
   click "Re-run this build".

1. On the "Dependencies" tab of the deploy configuration, ensure that "Deploy
   Canary to Production Environment" is set to "rebuild" to ensure that you
   rollback the canary as well.

1. On the "Parameters" tab of the deploy configuration, set "Minutes to
   Delay..." to 0 to ensure the rollback proceeds immediately.

1. Click "Run Build" to start. After the deploy completes, you can verify that
   both canary and production are running the correct versions by comparing the
   git hashes assigned to each environment.
