# Redirecting Erroneous Upsell Traffic

Since the upsell page catches all 2- and 3-part paths that are otherwise
unhandled, it winds up responding to a lot of paths that are not really upsell
opportunities and would better be handled by a different page in the TMW app or
by redirecting to desktop (Twilight). We have server middleware for handling
this functionality, and occasionally it is worth auditing the traffic rendered
by the upsell page to ensure that users are erroneously dead-ending there.

## Getting Metrics

You can view the number of pageviews the upsell page is getting by
[querying for the locations `mobile_upsell` and `mobile_upsell2` in Scout](https://scout.di.xarth.tv/pivot/d/416c83c17289797347/Raw_Pageview).
This can give you an indication of the overall rate of traffic.

To see which routes are actually getting sent there, you would need to go to
Mode and query `tahoe.pageview` to get information on the actual URLs. Grouping
by identical URLs (after dropping query params aka everything including and
after a `?`) should give you a good view of popular problematic paths.

## Mitigation

The general strategy is as follows:

1. Is this path sufficiently close to an existing TMW page? This can include not
   only close substitutes (like `/<login>/about` to `/<login>/profile`), but
   also deprecated routes (like `/<login>/mobile` to `/<login>`) or sufficiently
   popular typos (like `/video/<id>` to `/videos/<id>`). If yes, then in-app
   redirect.
1. Does this path correspond to an existing feature in the native mobile apps
   (like login-related functionality)? If yes, then upsell is the appropriate
   page.
1. Does this path correspond to a feature that only exists on the desktop site
   (like moderator- or dashboard-related functionality)? If yes, then redirect
   to Twilight.

### In-app redirects

For configuring new in-app redirects, you'll need to modify the
`PAGE_ALIAS_MIDDLEWARE_OPTS` and its `pageAliases` entries in
`.../config/redirects` in TMW. The best way to create new entries for this is to
first test them in the `pageAliasManager` test suite in the
`tachyon-server-utils` package, as the lists in the app's config are directly
copied from the lists in the test suite (for now).

### Desktop redirects

For configuring new desktop redirects, you'll need to modify the
`pathsToForceRedirect` in `.../config/redirects` in TMW. This should follow the
same process the public
[Mobile Web Redirects Process](../../apps/tomorrow/processes/mobile-web-redirects.md).
