# Deploying Valence

This document outlines how to perform a production deployment of Valence through
TeamCity.

In general, follow the same processes as
[Tomorrow](../tomorrow/deploying-tomorrow.md). Any notable differences will be
documented here.

**NOTE:** During a **SEV-1** announced in `#site-production` OR `#emergency` you
**MUST DEFER or ROLLBACK any deploys.**

## Pre-Deploy Verification

1. Deploy Valence on `main` to a
   [Tachyon Staging](../../processes/using-public-staging-environments.md)
   environment.
1. Within the Valence project, run `yarn proxy:start` to setup a local proxy.
1. Validate Valence by running `URL=<staging-url> yarn prodtest` in the
   [Valence package-example](../../package-examples/valence/README.md).
1. Deploy a different app over valence on the staging environment to prevent
   unintended use.

## Branch Gating

Valence is deployed from the `valence` branch.

To prep a new release, reset the `valence` branch on `main`:

```
git checkout valence
git reset --hard origin/main
git push origin valence
```

## Deploying

1. Go to the
   [Valence Production Deploy](https://teamcity.xarth.tv/buildConfiguration/EmergingPlatforms_Tachyon_ValenceProductionDeploy?branch=valence)
   view.
1. Click the kebab button next to the 'Deploy' button. A modal will open.
1. In the modal, navigate to the 'Changes' tab and select `valence` as the
   'Build branch'
1. Click the 'Run Build' button.
1. Announce the deploy in the #emp-deploys and in #site-production.
1. Post-deploy verification using `prodtest`
   [Valence Package Example README](../../package-examples/valence/README.md)
1. Post-deploy verification on PS5 (Coming Soon ™️)

## Recommended critical paths to manually verify:

Run the following checks using desktop Safari. Valence's support matrix is
Safari >= 13. Ideally we would test on Safari 13, but until we have a process in
place for developers, latest Safari is sufficient. An overview of active client
browsers is tracked on
[this dashboard](https://app.mode.com/twitch/reports/8ccca5d56f30).

NOTE: When verifying staging/production you still need to run valence locally
for its' proxy.

- Ensure Clip and Stream video play works
