# Code Reviews

This page covers how to request and perform code reviews for code contributions
typically referred to as "Pull Requests (PRs)" in
[Tachyon](https://git.xarth.tv/emerging-platforms/tachyon/pulls).

## Review Philosophies

We use
[Google's Code Review Guide](https://google.github.io/eng-practices/review/) for
inspiration.

**The Golden Rule**:

> In general, reviewers should favor approving a CL once it is in a state where
> it definitely improves the overall code health of the system being worked on,
> even if the CL isn’t perfect.

From
[The Standard of Code Review](https://google.github.io/eng-practices/review/reviewer/standard.html).

Other best practices:

- Consider the
  [Pit of Success](https://blog.codinghorror.com/falling-into-the-pit-of-success/)
  and how the change affects it.
- Be opinionated through automation. We defer to Prettier and ESLint wherever
  possible. If we feel strongly that a new convention should be followed, file
  tickets to add existing rules or create new ones rather than enforcing in
  existing PRs unless not following that convention would result in end user
  impact.
- Request "Fast Follows", improvements to be addressed in an immediate follow
  up, that go above and beyond the "golden rule". These should be used in cases
  where doing so increases overall project or team velocity unless it negatively
  impacts end users.

## Github Labels

We have created a number of
[Labels](https://git.xarth.tv/emerging-platforms/tachyon/labels) to help
communicate the intent of pull requests. Use them accordingly.

## Internal Code Review Policies

- "Ready For Review" PRs should be reviewed within 48 hours.
- "Priority Yay High" PRs should be reviewed within 24 hours.
