# On-Call

Emerging Platforms engineers are expected to follow a weekly on-call rotation.
This rotation exists to guarantee the team maintains its SLAs against production
services, handle deploys, and do
[dependency updates](../policies/dependency-upgrades.md).

Generally speaking, engineers will have 1 quarter to acclimate themselves with
the various services and systems with mobile web before they go on-call. This
might be expedited in cases where the team and individual consider this
reasonable.

## Slack Channels for On-Call

- #site-production (General updates about issues/deployments across Twitch)
- #emergency (Coordination of large scale events)
- #tmw-alerts (High priority issues that must be addressed quickly)
- #emp-deploys (Posting of production deploys)
- #mobile-web (On-Call triages any questions here)
- #tv-apps (On-Call triages any questions here)

## Schedule

On-Call rotates between engineers every Tuesday at 11 AM Pacific. The order is
that an engineer will go from "off call" ➡ "secondary on-call" ➡ "primary
on-call" ➡ "off call". The number of weeks you are off call is basically the
number of engineers on the team minus 2 with a floor of 0.

## Preparing for First On-Call

Before your first time as primary or secondary on-call you must do the following
things:

1. Read and ensure you have the "Prerequisites" from
   [Deploying Tomorrow](../apps/tomorrow/deploying-tomorrow.md).

1. File a [CSI](https://jira.twitch.com/projects/CSI) JIRA ticket requesting
   access to the [Mobile Web Fastly dashboard](https://manage.fastly.com/).

1. Create and configure your
   [Twitch Pagerduty Account](https://twitchoncall.pagerduty.com). Verify
   PagerDuty can page you.

1. Verify you can access
   [Amazon VPN](https://wiki.twitch.com/display/HD/Amazon+VPN) (Cisco AnyConnect
   client).

## Preparing for Subsequent On-Calls

For each on-call you should verify:

1. You can still login to Amazon's VPN (via Cisco AnyConnect client).
1. You can still access the **Admin** role for twitch-cpe+mweb in Isengard.

## Weekly On-Call Handoff

On-Call handoff happens weekly on Tuesdays. As part of this process, a
[Weekly Ops Sync Report](https://wiki.twitch.com/display/MWC/Weekly+Ops+Sync)
meeting occurs. This meeting should be run by the new primary on-call with
historical context provided by the previous on-call. The new on-call should
create the weekly report and fill it out according to the instructions.

## Temporary On-Call Override

On-call overrides are defined in PagerDuty. The following process should be
followed when temporarily overriding on-call:

1. Find someone to take on-call for you.
1. Get permission from that person to subsitute them in for the specific times.
1. Set the override in PagerDuty.
1. Post the override link into the private team channel `@`ing the replacement
   and verifying that they agree to the override.
