# Low Water Mark Alerts

## Background

A low water mark error indicates that we've stopped seeing errors being written
to CloudWatch logs. This could occur for two reasons:

1. We no longer have errors (including GQL errors, which tend to happen a couple
   times a minute).

1. Our logging system is no longer in alignment with our monitoring system.

1. No requests are going to m.twitch.tv origin (check here).

The first case is great, though highly unlikely since API errors tend to be a
pretty constant background noise. The second case is bad since we have somehow
blinded ourselves. The third case seems like something we should've gotten a
heads up on. We will not cover "what if mobile web goes away but somehow this is
the only alert that triggers" as it seems out of scope.

## Resolution

1. Check #emp-deploys to see if a recent deploy happened. If one did and it is
   safe to rollback then roll it back. This is almost certainly the issue.

1. Use the
   [GQL Errors Insight Query](./../../apps/tomorrow/logs-and-metrics.md#graphql-errors)
   to check if errors are still being reported.

1. If errors are found, then the filters have been broken:

   1. Go to the
      [Log Group overview](https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logs:)

   1. For the alarming Log Group, click the corresponding "Metric Filters" link
      and examine. The Metrics Filters view doesn't have a changelog or
      timestamps for individual filters, so this is not super helpful but this
      is where you modify them. Find the problem, update, and save.

1. If no results are returned then the logging system has stopped following the
   log format. You'll need to see what recent changes caused the logging system
   to stop recording the proper format and deploy a fix.
