# Unexpected Errors

## Background

The unexpected error alert triggers when the server sees an error that was not
gracefully handled by the application.

## Resolution

1. If this was triggered immedaitely after a deploy, verify it is safe to roll
   back and do so.

1. Use the `Unexpected Errors Insight Query` for the Tachyon application: to see
   the error(s), using the expected time range to help correlate log messages to
   the reported errors and figure out what is going wrong.

   | App                                                                                |
   | ---------------------------------------------------------------------------------- |
   | [Starshot](../../../apps/starshot/logs-and-metrics#filtering-on-unexpected-errors) |
   | [Tomorrow](../../../apps/tomorrow/logs-and-metrics#filtering-on-unexpected-errors) |
   | [Valence](../../../apps/valence/logs-and-metrics#filtering-on-unexpected-errors)   |

   1. Check #site-production for an ongoing INC or recent deploy announcement.
      If an incident is active, verify that this is the source of our unexpected
      errors. If so, communicate the approximate % of users being impacted and
      how.

   1. Once you find the error message, you can find more info about the entire
      request by
      [searching by request id](<https://us-west-2.console.aws.amazon.com/cloudwatch/home?region=us-west-2#logs-insights:queryDetail=~(end~0~start~-3600~timeType~%27RELATIVE~unit~%27seconds~editorString~%27fields*20*40timestamp*2c*20*40message*0a*7c*20filter*20*40requestId*20*3d*20*2238edd44c-8fe4-45f6-a00b-5d08a778457a*22~isLiveTail~false~queryId~%27*2faws*2flambda*2forigin-tachyon-mobile-web-prod-tachyonOrigin-1J3N2LK5HJQ6O~source~%27*2faws*2flambda*2forigin-tachyon-mobile-web-prod-tachyonOrigin-1J3N2LK5HJQ6O)>)
      (note that you'll need to replace the preloaded request id with the
      relevant one).

1. Develop a hot fix and deploy.
