# Emerging Platforms Engineer Onboarding

Welcome to the Emerging Platforms Platform Team!

This document was created to help guide you through the Emerging Platforms team
onboarding process and should serve as a useful guide through the processes,
policies, and technologies we work with.

## Daily Stand-ups

We do daily stand-ups at 11 AM Pacific over Google Meet. The format is as
follows:

- We give our updates in the order of last to arrive to first to arrive,
  physically or virtually
- An update should include what you accomplished yesterday, what you are working
  on today, and anything you are blocked on
- We intentionally extend stand-ups to discuss any relevant issues, but that
  does not mean you should wait until then to raise concerns.

## Weekly Meetings

- On-Call Hand off, Tuesday at 1pm PST

## Slack

Most of our communications happen in Slack. Please try to keep work-relevant
conversations in the appropriate team channel instead of direct messages (DM's)
so that the whole team can benefit from sharing knowledge.

We monitor our public facing #mobile-web and #tachyon-lib-support channels to
provide support or house discussions started from other teams. Encourage product
developers to move conversations here so we can all learn and improve from them.

These other channels often contain useful discussions as well:

- frontend-engineering - Discussions relevant to technology & concepts relevant
  to FEEs.
- graphql - Support and future planning discussions about our GraphQL API.
- core-ui-support - Support for our component library.
- mobile-web-player - We coordinate video player related concerns with the Video
  Playback team here.

## Project Management

We use Jira. See [Project Management](./project-management.md) for an in-depth
guide.

## General Onboarding Tasks

1. Setup Slack and ask someone from our team to add you to relevant Emerging
   Platforms channels.

1. Setup [Twitch VPN](https://wiki.twitch.com/display/HD/Twitch+VPN) and
   [Single Sign-On](https://wiki.twitch.com/pages/viewpage.action?pageId=176683680).

1. Get a Yubikey from IT.

1. Use the Yubikey to setup
   [Amazon VPN](https://wiki.twitch.com/display/HD/Amazon+VPN).

1. Setup
   [Amazon Enterprise Access](https://wiki.twitch.com/pages/viewpage.action?pageId=181471419).

1. Ask your manager to add you to the
   [Emerging Platforms](https://dashboard.xarth.tv/ldaptools/group/mobileweb)
   LDAP group.

1. Setup [Tachyon](../README.md), our monorepo.

1. Install the required simulators via the
   [Mobile Web Device Testing](../apps/tomorrow/processes/device-testing.md)
   guide.

1. Run our [Tomorrow](../apps/tomorrow/README.md) client in both the Android and
   iOS Simulator.

1. Setup a
   [GraphQL Playground](https://git.xarth.tv/pages/edge/graphql-docs/exploring-schema/#graphql-playground--graphiql)
   for Twitch's GQL implementation.

## Code Reviews

Read our [Code Review](./code-reviews.md) guidelines.

## Useful Learning Resources

Here is a list of books, blog posts, and videos to watch that will give you
better insight and understanding of mobile web as a platform.

**[The Future of the Mobile Web](https://www.youtube.com/watch?v=rWYifOE8LDc&t=22s)
by Paul Kinlan.**

This video does a great job of providing the history of mobile web, explaining
the constraints of browsing on a mobile phone browser, what is in development,
and what the advantages of mobile web are over traditional Native apps in
emerging markets with extremely resource constrained phones.

**[Getting Started with Progressive Web Apps](https://addyosmani.com/blog/getting-started-with-progressive-web-apps/)
by Addy Osmani**

A nice overview of PWAs and how to get started.

**[Measuring Performance with the Rail Model](https://developers.google.com/web/fundamentals/performance/rail)**

**[High Performance Browser Networks](https://hpbn.co)**

Now that you understand the challenges that a mobile optimized web experience
faces, it is time to apply some practical theory to understand why these
challenges exist and how to account for them.

**[Planning for Performance: PRPL](https://www.youtube.com/watch?v=RWLzUnESylc)**

This talk goes over the PRPL pattern. The PRPL pattern is a good pattern to use
when working with PWAs. It is defined as:

- **Push** critical resources for the initial page.
- **Render** the initial route.
- **Pre-Cache** remaining routes.
- **Lazy-Load** remaining routes on demand.

**[Progressive Performance](https://www.youtube.com/watch?v=4bZvq3nodf4)**

A good talk on performance on low-power devices and bad networks.

**[Breaking the 1000ms Time to Glass Mobile Barrier](https://www.youtube.com/watch?v=Il4swGfTOSM)**

An exceptional talk from Ilya Grigorik where he walks through the network
requests to define the available budget for a mobile web app to meet a 1s goal.

**[TypeScript Docs](https://www.typescriptlang.org/docs/tutorial.html)**

The base documentation for TypeScript.

**[TypeScript Weekly](http://paper.li/ronniedrengen/1386937876)**

A weekly TS newsletter. This is a low-cost resource to see a few neat
developments each week. It will pretty much always catch the big stuff.

**[AMP](https://www.ampproject.org/)**

A basic overview of Accelerated Mobile Pages. We don't use AMP, but maybe we
will some day. Either way, people will ask your opinion on it at some point so
you should have an informed one.

**[Google Developers Web](https://developers.google.com/web/)**

Lots of useful information around Browser API's, PWA's, Chrome, Performance,
etc.

**[This.Javascript](https://www.youtube.com/playlist?list=PL-G5r6j4GptGtyEflzZZ0CdeL_aoUDZ-R)**

Live streamed YouTube series on Frontend Concepts.

**[Modern.Web Podcast](https://www.youtube.com/playlist?list=PL-G5r6j4GptFBmxZGbtqT_1mb_sUgCs4T)**

Another good live streamed YouTube series on Frontend Concepts also available in
Podcast format.

## Amazon Internal Resources

**[Amazon Wiki](https://w.amazon.com/bin/view/Main/)**

All kinds of useful documentation and resources.

**[KNET](https://knet.csod.com/LMS/catalog/Welcome.aspx)**

Free, virtual courses, that Amazon has created for almost anything you can
imagine.
