# Managing TV Apps Teamcity Mac Agents

This document refers to the legacy Twitch TV apps, which are considered
deprecated, but are still periodically maintained with small fixes while we
migrate over to Starshot.

However, this information is probably broadly applicable to other Mac EC2
instances, so this document may continue to be useful in the future after we've
fully moved off of TV apps.

For more information about TV apps environment setup and build steps, see the
[Confluence wiki](https://wiki.xarth.tv/display/CAP/TV+Apps).

## Get Access Via Isengard

The first thing you'll want to do is log into
[Isengard](https://isengard.amazon.com) and click on "AWS Console Access" in the
left-hand menu. From there, search for `tvapps` in the search box. You will need
to make sure you have admin access to
`twitch-teamcity-mac-agents-tvapps@amazon.com`. If you don't have access,
contact your manager.

## Locate the TV Apps Agent EC2 Instances

From the Isengard dashboard, click the "admin" button next to the
`twitch-teamcity-mac-agents-tvapps@amazon.com` account.

![Isengard Dashboard](../../apps/sky-map/public/static/native-apps/tvapps-agents/1_isengard_console.png)

You should be taken to an AWS management page. First, verify that your AWS
region is set to Oregon (`us-west-2`). You can check this in the top right
corner of the AWS dashboard.

![Region Selector](../../apps/sky-map/public/static/native-apps/tvapps-agents/2_region.png)

Next, click on "EC2" which will be either listed under "Recently Visited
Services" or under "All Services" if you haven't previously managed any EC2
instances.

![AWS Management Console](../../apps/sky-map/public/static/native-apps/tvapps-agents/3_aws_console.png)

You should be taken to a page containing a bunch of information about EC2. You
should see a link to four instances, one for each agent. Click this link.

![EC2 Console](../../apps/sky-map/public/static/native-apps/tvapps-agents/4_ec2_console.png)

From here, you'll be taken to the list of instances. You'll observe that the
instance IDs correspond to the names of the agents in the TeamCity agents
dashboard. In order to connect to one, select the check box next to the
instance, and then click the connect button at the top of the page.

![Select Your Instance](../../apps/sky-map/public/static/native-apps/tvapps-agents/5_select_instance.png)

## Connecting Via the AWS Session Manager

The easiest way to access one of the agents is via the session manager that's
built into the AWS web interface. If you followed the above steps and clicked
"Connect", you should arrive at a page with several connection options. Select
"Session Manager" and then "Connect", and a new window should open up with a
terminal.

![Connect via Session Manager](../../apps/sky-map/public/static/native-apps/tvapps-agents/6_session_manager.png)

From this terminal, you just need to switch your user to the `teamcity` user
account, and you can run commands directly on the agent's terminal and inspect
any logs of running builds.

```sh
$ sudo bash
$ su - teamcity
```

![Session Manager Console](../../apps/sky-map/public/static/native-apps/tvapps-agents/7_console.png)

## Connecting Via SSH

It's possible you may want to use your own terminal if you're going to be doing
some more advanced debugging where the online console just doesn't cut it. You
can set up your machine to be able to SSH to the EC2 instance with a few extra
steps.

### Software Prerequisites

#### AWS CLI tools

The AWS command line tools can be installed using homebrew

```sh
$ brew install awscli
```

#### isengard_credentials

Follow the steps in the
[isengard_credentials repo](https://git.xarth.tv/twitch/isengard_credentials) in
order to install this tool and add it to your path.

### Modify Your Local AWS Credentials File

Using your favorite text editor, open up `~/.aws/credentials`

To the bottom of the file, append the following:

```sh
[ec2tvapps]
region = us-west-2
credential_process = isengard_credentials --account-id 365848631295 --role admin
```

### Modify your SSH config

Using your favorite text editor, open up `~/.ssh/config`

To the bottom of the file, append the following:

```sh
# TVApps
host i-003b25434253bd0b9 i-04ffcfeb75278b372 i-0e4f6734b0aaed708 i-0a79538184e9c7d81
    ProxyCommand sh -c "aws --profile ec2tvapps ssm start-session --target %h --document-name AWS-StartSSHSession --parameters 'portNumber=%p'"

```

### Connect to the instance

If all went according to plan, you should now be able to SSH into the instance
from your terminal (`i-003b25434253bd0b9` is used as an example, but you could
substitute in a different instance ID if you wanted to connect to a different
agent):

```sh
$ ssh teamcity@i-003b25434253bd0b9
```

⚠️ Potential pitfall ⚠️ If you get a `permission denied (publickey)` error, you
may need to follow the above steps to open a terminal in the AWS web interface
and manually edit `/Users/teamcity/.ssh/authorized_keys` and append the contents
of your `~/.ssh/id_rsa.pub` (or wherever your SSH public key is stored on your
system)

## Connecting Via Remote Desktop

Once you've set up SSH, you can also remote desktop into the instance through a
local proxy. Just run the following command in your terminal, where the instance
ID in the command could be substituted with the ID of the instance you wish to
connect to.

```sh
$ ssh -L 5900:localhost:5900 -C -N teamcity@i-003b25434253bd0b9
```

Once you've run this command in your terminal, go to your web browser and
navigate to `vnc://localhost:5900`. This should open the Mac Screen Sharing app,
and prompt you to enter a username and password. For the username, use
`teamcity`. The password is located in the AWS secrets console. Go to
[the console](https://us-west-2.console.aws.amazon.com/secretsmanager/home?region=us-west-2#!/secret?name=login)
and select "Retrieve secret value" to reveal the password you should use to
connect.

At this point, you should be greeted with a login screen for the EC2 instance.
Use the same username and password that you just used to connect to the screen
sharing app, and you should be dropped into the desktop of the remote instance.

⚠️ **IMPORTANT** ⚠️ When you are done with your session, don't select "Log out"
from the Apple menu in the top left. Simply close the screen sharing window and
that will be sufficient. Logging out of the machine will cause some processes to
terminate which need to remain running for the agent to function.
