# Publishing Tachyon Monorepo Packages

## Preparing To Publish

1. Be on Twitch's VPN.
1. Setup
   [Artifactory](https://wiki.twitch.com/display/DTA/Artifactory%3A+User+Guides#Artifactory:UserGuides-ArtifactoryAPIKey)
   credentials on your machine.

## Versioning

To choose the correct next version number, refer to the pending version number
in the [CHANGELOG](../CHANGELOG.md). It should include the correct scope for the
unpublished changes.

## Publishing to our Internal NPM

We publish our packages using Lerna, which handles incrementing versions across
the dependencies and sending them all to our internal registry. It also tags our
releases in GHE.

To publish, from the root of Tachyon, run:

```sh
$ yarn pub
```

## After publishing

After publishing, add another commit to the `publish` branch that includes the
following:

- the automatically bumped tachyon package versions from the publish command

- an updated [CHANGELOG](../CHANGELOG.md) marking the publish date to the
  just-released version entry and creating a new pending version entry that is a
  patch revision of the version you just published with an empty changeset

- updates the tachyon library versions in the various template `package.json`
  files to be equal to the current version in the repo

Finally, open a Pull Request with these changes.

### PR updates

After you publish a release, do a quick scan of any open PRs to find ones that
introduce new packages, new intra-monorepo dependencies, or new CHANGELOG
entries. These will all need to be updated to reference the new repo version
number accordingly (eg bumping versions in package.json or moving CHANGELOG
entries into the new pending section). It can also be useful to search the repo
for instances of the old version number to see if any slipped through previous
publishes.

## Announce

Announce the release in tachyon-lib-support linking to Tachyon's
[CHANGELOG](../CHANGELOG.md) and cross post to frontend-engineering.
