# Updating Dependencies

More to come

## Pinned Dependencies

We have some dependencies that currently cannot be upgraded beyond their current
versions. We list them here with their reasons.

### Blocked until Webpack 5

The following dependencies cannot be upgraded until they move alongside
Webpack 5. They all have a hard-dependency on Webpack 5.

- webpack < 5
- webpack-cli < 4
- webpack-node-externals < 3
- terser-webpack-plugin < 5
- next-transpile-modules < 8
- next-pwa < 5.2.5 (there are also some versions that break TMW's SW)
- copy-webpack-plugin < 7

The following dependencies are soft-blocked by Webpack 5, as they have been
converted to ESM. We could add additional configuration for them to work in
Webpack 4, but instead of wasting time on that we're waiting until 5 where
handling them becomes much easier.

- globby < 12
- mem < 7
- mimic-fn < 4
- node-fetch < 3
- quick-lru < 6
- react-markdown < 7
- rehype-raw < 6
- remark-gfm < 2

### @types/node

We keep our Node types in line with the LTS version of Node we are using.

### player-core

Player Core is not updated as part of the normal dependency upgrade pass. VP
will make specific PRs for validating new versions against TMW with their QA
team.

### Intl

The following are hard-dependencies of `twitch-intl`. v3 of them was a major
rewrite, dropping functionality upon which `twitch-intl` relies, so we will
probably never update them.

- intl-messageformat
- intl-relativeformat

### branch-sdk

The Branch SDK has been seriously patched to not include large portions of the
original package. This process is miserable (thanks Jonas!) and so we don't mess
with it unless we have to.

### date-fns

Currently `date-fns` is used in the twilight-date-picker package, which is only
in Tachyon temporarily while Core UI develops a replacement. As a result, we
don't bother with attempting to update it.

## Patches

To install patches, you have to temporarily remove any resolutions that come
from our internal NPM repository as `patch-package` will otherwise choke. After
you generate a patch file, ensure that you remove all the README/etc noise that
is generated as part of our usage of `yarn clean` and scope it solely to the
intended change; comparing the new patch to the old patch can help sanity check
the new version. Also note your change here for future maintainers.

### branch-sdk

This is patched to remove several unused parts from the package to slim it down.

### next

We patch `next/dist/client/next.js` to remove the `.catch(console.error)` from
the `next()` invocation so that top-level errors aren't swallowed and instead
hit our window-level error-reporting.

### node-notifier-cli

This package is patched to force passing `{ timeout: false }` to
`notifier.notify()` to prevent processes from incorrectly hanging.
