# Working With Ensemble QA

Emerging Platforms contracts out QA testing work to a company called Ensemble,
based out of Richmond, BC (Pacific time zone). Our main contacts with Ensemble
are:

- [Olga Shramko](mailto:olgas@ensemble.com): Native TV apps QA lead
- [Adrian Wai](mailto:adrianw@ensemble.com): TV web QA lead
- [Jeff Wong](mailto:jeffw@ensemble.com): Mobile QA lead, also the team lead for
  all Twitch QA efforts, keep Jeff in the loop on most communications with QA
  that happen over e-mail
- [Danny Yu](mailto:dannyy@ensemble.com): QA manager, main point of contact for
  resourcing asks as well as a good resource to ask if you're not who is
  responsible for a certain aspect of testing

The best way to reach the QA team is just to message them in the
[#emp-qa](https://twitch.slack.com/archives/G85GLRL72) Slack channel. If you
assign them a ticket without a corresponding Slack message, you may get a slower
response.

## Ensemble's QA Test Pass Process

Each team is responsible for scheduling their own QA passes on a schedule that
makes sense for their app.

### Starshot

Starshot typically does a QA test pass every three weeks. Each test pass, the QA
team will run through the
[Starshot Regression Test Plan](https://docs.google.com/spreadsheets/d/1ghiDPvxtdRLys2aF-5ZwJ5TTsrArTLeExitqZjXZqCs/edit#gid=2097583604),
which is a full suite of tests to verify the functionality of the entire app. It
takes one QA tester about 1.5 days to complete a regression cycle on a single
television. Two testers working in parallel will usually finish in about 2 - 2.5
days, though this will grow as we add more devices to the support matrix for
living room.

### Mobile Web

Currently Mobile Web lacks a full test plan. QA usually just performs ad hoc
testing. This is probably an area we should improve upon at some point in the
future.

### ⚠️ Important Note About TV Testing

Testers don't have televisions in their homes. They go into the office to test
with the smart TV devices. The result of this is that usually they can't
immediately begin a QA regression for Starshot unless you notify them a few days
in advance so they can plan to take a trip into the office.

## Scheduling a New QA Test Pass

At a high level, the process looks like:

1. Create a clone of [this ticket](https://jira.xarth.tv/browse/EMP-3860)
2. Add the information about the test you want QA to run.
3. Assign the ticket to the appropriate QA lead (see the top of this doc)
4. Send a ping to QA in [#emp-qa](https://twitch.slack.com/archives/G85GLRL72)

### Filling Out the QA Request Ticket

In order to schedule a QA pass, the first step is to clone
[this ticket](https://jira.xarth.tv/browse/EMP-3860).

In the title of the ticket, please include the platforms that you want tested as
well a summary of the requested test.

In the body of the ticket, describe what kind of test you'd like QA to run.
Examples:

- Full regression. QA will run through their full test plan against the
  specified devices.
- Smoke Test. QA will just run through their minimal test suite that checks
  against the most critical paths to verify app functionality. Can be run in
  just 1-2 hours per device.
- Player Regression Test. QA will run a short test suite similar to a smoke
  test, but specifically aimed at checking for possible bugs as a result of a
  new Player Core integration. QA test plan has yet to be written on the
  Ensemble side, but should probably be based off
  [Upgrading Player Core](../../processes/upgrading-player-core.md)
- Any other kind of custom test you want to run (usually Ensemble is pretty
  flexible if you describe to them what you want to the QA lead)

Provide a build for QA to test against. This will be dependent on the platform.
If the build is small enough, the easiest thing to do is to attach the build
directly to the ticket. However, for some larger builds you will probably want
to upload the file to Google Drive or Dropbox.

- **Mobile web**: deploy to a staging environment and tell QA which environment
  to test against
- **LGTV**: Build a new IPK pointing at the staging environment that you want to
  test and provide this to QA. This step could probably be skipped if no changes
  have been made to Laser Array since the last submission.
- **Vestel/Hi-Sense/Vizio**: Deploy to a staging environment and provide QA with
  the URL.
- **Nintendo Switch**: Provide an NSP file to QA. This build should be pointing
  at the staging environment that you want to test. This step is not necessary
  if no changes have been made to the app shell.
- **Android TV**: Provide an AAB file to QA which is pointing at the staging
  environment you want to test. This step is not necessary if no changes have
  been made to the app shell.
- **Fire TV**: Provide an APK file to QA which is pointing at the staging
  environment you want to test. This step is not necessary if no changes have
  been made to the app shell.

Assign the ticket to the appropriate QA lead (usually Adrian or Olga) and notify
them via Slack (#emp-qa) that you've made the ticket.

## Updating the Test Plan

When adding or changing parts of the app, you'll often need to make
corresponding updates to the test plan to ensure that QA doesn't file
unnecessary bugs every time they go through a regression pass.

### Making Small Changes to the Test Plan

In order to make a small change to application behavior, probably the best thing
to do is just to send a message to the appropriate QA lead in the
[#emp-qa](https://twitch.slack.com/archives/G85GLRL72) slack channel and to also
leave a comment on the appropriate test cases in the main test plan spreadsheet
indicating why they need to be removed or modified.

### Adding New Features to the Test Plan

Test plans are created as a collaborative effort between engineers working on
Tachyon and the Ensemble team. Once an engineer has finished developing a
feature and is ready for QA to add it to the test plan, the engineer should:

1. Schedule a meeting with the QA test lead for their app (see the top of this
   doc)
2. Include any engineers who worked on the feature, and optionally can include
   the engineering manager as well.
3. Within the calendar invite, include links to the product spec as well as the
   Figma mocks, if relevant.
4. When this meeting has been scheduled, also ping the QA lead in
   [#emp-qa](https://twitch.slack.com/archives/G85GLRL72)
