# Project Management

This page covers the Emerging Platform org's policies and processes around
project management.

## Project Tracking

- Twitch uses [JIRA](https://jira.twitch.com/) for project tracking.
- Emerging Platforms tracks work within the
  [EMP](https://jira.twitch.com/projects/EMP/summary) JIRA project.
- We follow the
  [Univeral Severity Guide](https://wiki.twitch.com/display/SEC/Universal+Severity+Standard)
  for acknowledging and prioritizing bugs.
- New stories are triaged (assigned a priority in our backlog and level of
  effort) every Tuesday for both Core Platforms and Living Rooms teams

## Backlogs

[Core Platforms](https://jira.xarth.tv/secure/RapidBoard.jspa?rapidView=1794&projectKey=EMP&view=planning&issueLimit=100)
[Living Room](https://jira.xarth.tv/secure/RapidBoard.jspa?rapidView=1850&projectKey=EMP&useStoredSettings=true)

## Creating Work Items

### Epics

Epics are reserved for arcs of work that have definite tracks of work that we
are accountable for and need to report upwards. Matt will typically decide when
an epic is necessary. Use Components and Labels (outlined below) for classifying
work more generally in helpful ways.

### Stories And Bugs

Specific work tickets must be of type "Story" or "Bug". There are a number of
pieces of metadata to fill in when filing a ticket in order to give us better
visibility and prioritization capabilities.

**[Components](https://jira.twitch.com/projects/MWC?selectedItem=com.atlassian.jira.jira-projects-plugin:components-page):**

These map 1:1 to apps, packages, and systems our team are responsible for. More
than one component can be assigned to a ticket.

### Labels

We use labels to cause tickets to appear in team-specific JIRA boards /
backlogs:

- "core-platforms"
- "living-room"

### Estimating Level Of Effort (Pointing)

We estimate the relative complexity of stories using a numerical system based on
fibonacci:

| Points | Examples                                                                                    |
| ------ | ------------------------------------------------------------------------------------------- |
| 1      | Not typically used.                                                                         |
| 2      | Updating strings, fixing a test, simple dependency update                                   |
| 3      | Simple bug fixes, minor refactors or feature changes                                        |
| 5      | Non-trivial bug fixes/refactors, new functionality                                          |
| 8      | Large changes affecting two or more apps/packages, major bugs, some unknown complexity      |
| 13     | Critical changes of large or unknown complexity. (Break into smaller sub-tasks if possible) |
| 21     | Unused, create a planning ticket and generate smaller, broken down, tasks                   |

Bug investigations default to a complexity of "5". If this uncovers a larger arc
of work, that will be ticketed as a separate story and estimated accordingly.

## Ticket Assignment

- Tickets are typically taken just-in-time when someone has free capacity to
  take on new work.
- Tickets should always be taken from the top of the backlog within reason
  (don't take something massive on a Friday).
- Tickets that are "flagged" have a dependency that is blocking them or they
  would otherwise be in progress.
- Some tickets will be assigned upfront if it is a continuation of a particular
  arc of work.

## Useful Dashboards

##### [Quick Improvements](https://jira.twitch.com/secure/Dashboard.jspa?selectPageId=33409)

Easy tasks that can be done to improve Tachyon.
