# Starshot 64 Android

A thin wrapper application that runs the Twitch TV web app (starshot) on Android
TV and Fire TV devices.

It also includes the recommendations service that displays rows of Twitch tiles
in the Android dashboard.

Progress on the application is being tracked in the following epics:

- https://jira.twitch.com/browse/EMP-3532
- https://jira.twitch.com/browse/EMP-3533
- https://jira.twitch.com/browse/EMP-3534

## Launch Arguments

### debug-laser-array

Set this to 1 to force the app to launch the offline Laser Array content with
`mode=native-error`.

For example, `-e "debug-laser-array" 1`

### debug-starshot-host

This allows an alternative Starshot URL to be specified. For example, to connect
to your local Starshot instance:

`-e "debug-starshot-host" "192.168.1.27:19000"`

### debug-url-params

Append any extra URL parameters here as needed. This needs to be pre-escaped in
order to be properly formed when appended to the URL.

## Code Formatting Rules

I don't really have strong feelings about code formatting, but I like not having
to think about it, so I went with using [Ktlint](https://ktlint.github.io/) as
an easy tool to enforce consistent code formatting style.

Once you've installed the linter, you can check for errors using (from the root
of the project):

```shell
ktlint --android ./app/src/**/*.kt
```

You can add the `-F` flag to this to allow the tool to automatically make
changes to bring your code into compliance (though it has some limitations on
its ability to automatically modify your code).

It's also a good idea if you work with Android Studio as your IDE to install the
linting rules into Android Studio's configuration so that you can use the
built-in code formatting without leaving the IDE.

**TODO: When we implement CI, add a check for formatting. Possibly also add a
pre-commit hook to check for this.**

```shell
ktlint --android applyToIDEA
```

## Testing MediaSession

Add the following to your ~/.bash_profile. It allows you to fake button presses
from a remote to facilitate testing.

```
# ADB MediaSession aliasas
alias msplay='adb shell input keyevent 126'
alias mspause='adb shell input keyevent 127'
alias msplaypause='adb shell input keyevent 85'
alias msstop='adb shell input keyevent 86'
alias msrw='adb shell input keyevent 89'
alias msff='adb shell input keyevent 90'
```
