package tv.twitch.starshot64.app

import timber.log.Timber

/**
 * Manages calls between native and Laser Array running in a webview.
 */
class LaserArrayNativeProxy(javascriptHooks: IInvokeJavascript) : NativeProxyBase(javascriptHooks) {

  var laserArrayErrorRetryCallback: () -> Unit = {}

  //region Callbacks from Starshot

  @android.webkit.JavascriptInterface
  fun laserArrayErrorRetry() {
    Timber.i("Received laserArrayErrorRetry callback from Laser Array")
    laserArrayErrorRetryCallback()
  }

  //endregion
}
