package tv.twitch.starshot64.app

import android.webkit.WebView

/**
 * Base class for native proxy implementations.
 */
abstract class NativeProxyBase(val javascriptHooks: IInvokeJavascript)

interface IInvokeJavascript {
  fun invoke(script: String)
}

class WebViewScriptInvoker : IInvokeJavascript {
  lateinit var webView: WebView
  override fun invoke(script: String) {
    val wrapped = "javascript:(function() {" + script + "} )();"
    webView.loadUrl(wrapped)
  }
}

/**
 * NOOP script invoker for instances where there are no exposed entrypoints in the
 * active web app.
 */
class NoopScriptInvoker : IInvokeJavascript {
  override fun invoke(script: String) {
  }
}
