package tv.twitch.starshot64.app

import android.app.Application
import timber.log.Timber
import tv.twitch.starshot64.BuildConfig
import tv.twitch.starshot64.analytics.NativeShellLaunchTrackingEvent
import tv.twitch.starshot64.analytics.initializeTracking
import tv.twitch.starshot64.analytics.sendTrackingEvent

class StarshotApplication : Application() {
  override fun onCreate() {
    super.onCreate()
    Timber.d("StarshotApplication.onCreate")

    if (BuildConfig.BUILD_TYPE != "shipping") {
      Timber.plant(Timber.DebugTree())
    }

    // Initialize the tracking subsystem
    initializeTracking(this)

    sendTrackingEvent(NativeShellLaunchTrackingEvent())
  }
}
