package tv.twitch.starshot64.app

import android.net.Uri
import tv.twitch.starshot64.BuildConfig

class StarshotConfig {
  companion object {
    private const val androidTvProductionHost = "androidtv.tv.twitch.tv"
    private const val fireTvProductionHost = "firetv.tv.twitch.tv"

    private var selectedHost = ""

    init {
      selectedHost = if (isFireTv()) {
        fireTvProductionHost
      } else {
        androidTvProductionHost
      }
    }

    /**
     * Determines the web application URL.
     */
    fun getAppUrl(): Uri {
      return Uri.parse("https://$selectedHost")
    }

    fun setAppHost(hostname: String) {
      selectedHost = hostname
    }

    fun getCookieDomain(): String {
      return selectedHost
    }

    fun isAndroidTv(): Boolean {
      return BuildConfig.TWITCH_PLATFORM === "androidtv_web_tv"
    }

    fun isFireTv(): Boolean {
      return BuildConfig.TWITCH_PLATFORM === "firetv_web_tv"
    }
  }
}
