package tv.twitch.starshot64.net.graphql

import android.content.Context
import android.os.Looper
import com.apollographql.apollo.ApolloClient
import okhttp3.Interceptor
import okhttp3.OkHttpClient
import okhttp3.Response
import tv.twitch.starshot64.BuildConfig
import tv.twitch.starshot64.util.getAccessToken
import tv.twitch.starshot64.util.getDeviceId
import tv.twitch.starshot64.util.getLocaleString

private class TwitchHeadersInterceptor(val context: Context) : Interceptor {
  override fun intercept(chain: Interceptor.Chain): Response {
    val requestBuilder = chain.request().newBuilder()
      .addHeader("Client-ID", BuildConfig.TWITCH_CLIENT_ID)
      .addHeader("X-Device-Id", getDeviceId(context))
      .addHeader("Accept-Language", getLocaleString())

    val accessToken = getAccessToken(context)
    if (accessToken != "") {
      requestBuilder.addHeader("Authorization", "OAuth $accessToken")
    }

    return chain.proceed(requestBuilder.build())
  }
}

private var clientInstance: ApolloClient? = null

fun sharedApolloClient(context: Context): ApolloClient {
  check(Looper.myLooper() == Looper.getMainLooper()) {
    "Only the main thread can get the apolloClient instance"
  }

  if (clientInstance != null) {
    return clientInstance!!
  }

  clientInstance = newApolloClient(context)

  return clientInstance!!
}

fun newApolloClient(context: Context): ApolloClient {
  return ApolloClient.builder()
    .serverUrl("https://gql.twitch.tv/gql")
    .okHttpClient(
      OkHttpClient.Builder()
        .addInterceptor(TwitchHeadersInterceptor(context))
        .build()
    )
    .build()
}
