package tv.twitch.starshot64.recommendations

import android.content.Context
import tv.twitch.fragment.GameFragment
import tv.twitch.fragment.StreamFragment
import tv.twitch.fragment.VideoFragment

interface IRecommendationsStrategy {
  fun handleActivityStarted(context: Context)

  fun handleBootCompleted(context: Context)

  fun handleLocaleChanged(context: Context)

  fun handleInitializePrograms(context: Context) {}

  fun updateRecommendedStreams(context: Context, streams: Iterable<StreamFragment>)

  fun updateRecommendedGames(context: Context, games: Iterable<GameFragment>) {}

  fun updateWatchNextVideos(context: Context, videos: Iterable<VideoFragment>) {}

  fun handleRemoveWatchNextProgram(context: Context, programId: Long) {}
}
