package tv.twitch.starshot64.recommendations

import android.os.Build
import timber.log.Timber
import tv.twitch.starshot64.BuildConfig
import tv.twitch.starshot64.recommendations.channel.ChannelRecommendationsStrategy
import tv.twitch.starshot64.recommendations.legacy.NotificationRecommendationsStrategy

private val logger = Timber.tag("RecommStratLocator")

private object RecommendationsStrategyLocator {
  var recsStrategyInstance: IRecommendationsStrategy? = null
}

private fun createRecommendationsStrategy(): IRecommendationsStrategy {
  return if (BuildConfig.FLAVOR == "amazon" || Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
    logger.d("Creating NotificationRecommendationsStrategy")
    NotificationRecommendationsStrategy()
  } else {
    logger.d("Creating ChannelRecommendationsStrategy")
    ChannelRecommendationsStrategy()
  }
}

fun getRecommendationsStrategy(): IRecommendationsStrategy {

  if (RecommendationsStrategyLocator.recsStrategyInstance != null) {
    return RecommendationsStrategyLocator.recsStrategyInstance!!
  }

  val strategy = createRecommendationsStrategy()
  RecommendationsStrategyLocator.recsStrategyInstance = strategy
  return strategy
}
