package tv.twitch.starshot64.recommendations

import android.net.Uri

private const val TT_MEDIUM = "android-shelf"

fun createHomeUri(ttContent: String): Uri {
  return Uri.Builder()
    .scheme("twitch")
    .authority("home")
    .appendQueryParameter("tt_content", ttContent)
    .appendQueryParameter("tt_medium", TT_MEDIUM)
    .build()
}

fun createStreamUri(channelName: String, ttContent: String): Uri {
  return Uri.Builder()
    .scheme("twitch")
    .authority("stream")
    .appendPath(channelName)
    .appendQueryParameter("tt_content", ttContent)
    .appendQueryParameter("tt_medium", TT_MEDIUM)
    .build()
}

fun createGameUri(gameName: String, ttContent: String): Uri {
  return Uri.Builder()
    .scheme("twitch")
    .authority("game")
    .appendPath(gameName)
    .appendQueryParameter("tt_content", ttContent)
    .appendQueryParameter("tt_medium", TT_MEDIUM)
    .build()
}

fun createVideoUri(videoId: String, ttContent: String): Uri {
  return Uri.Builder()
    .scheme("twitch")
    .authority("video")
    .appendPath(videoId)
    .appendQueryParameter("tt_content", ttContent)
    .appendQueryParameter("tt_medium", TT_MEDIUM)
    .build()
}
