package tv.twitch.starshot64.util

import android.content.Context
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.graphics.Canvas
import android.graphics.drawable.VectorDrawable

/**
 * Converts a resource into a [Bitmap]. If the resource is a vector drawable, it will be
 * drawn into a new Bitmap. Otherwise the [BitmapFactory] will decode the resource.
 *
 * @param context used for getting the drawable from resources.
 * @param resourceId of the drawable.
 * @return a bitmap of the resource.
 */
fun convertResourceToBitmap(context: Context, resourceId: Int): Bitmap {
  val drawable = context.getDrawable(resourceId)
  return if (drawable is VectorDrawable) {
    val bitmap = Bitmap.createBitmap(
      drawable.getIntrinsicWidth(),
      drawable.getIntrinsicHeight(),
      Bitmap.Config.ARGB_8888
    )
    val canvas = Canvas(bitmap)
    drawable.setBounds(0, 0, canvas.width, canvas.height)
    drawable.draw(canvas)
    bitmap
  } else {
    BitmapFactory.decodeResource(context.resources, resourceId)
  }
}
