package tv.twitch.starshot64.util

/**
 * Given several collections of elements, take the first N non-null elements by taking
 * from the provided sources in order. It's possible some sources may be empty or not
 * have enough elements on their own.
 */
fun <T> takeFirstNotNullN(n: Int, sources: Iterable<Iterable<T>?>): Iterable<T> {
  val result = ArrayList<T>()

  sources.filterNotNull().forEach { source ->
    result.addAll(source.take(n - result.size))
  }

  return result
}
