package tv.twitch.starshot64.util

import android.content.res.Resources
import androidx.core.os.ConfigurationCompat

fun getLocaleString(): String {
  val deviceLocales =
    ConfigurationCompat.getLocales(Resources.getSystem().configuration)
  val locale = if (deviceLocales.isEmpty) null else deviceLocales[0]
  val languageCode = if (locale == null) "en" else deviceLocales[0].language
  val countryCode = if (locale == null) "US" else deviceLocales[0].country
  return String.format("%s-%s", languageCode, countryCode)
}

fun getLanguageCode(): String {
  val deviceLocales =
    ConfigurationCompat.getLocales(Resources.getSystem().configuration)
  val locale = if (deviceLocales.isEmpty) null else deviceLocales[0]
  return if (locale == null) "en" else deviceLocales[0].language
}
